//************************************************************
//  Copyright (c) Ԫ΢޹˾
//	ļ	: main.c
//			: 
//	ģ鹦	:  Demo
//	ֲб:
//  : 2020/10/16
// 	汾		: V1.0   
//*************************************************************

#include "stdio.h"
#include "SensorMethod.h"
#include "SC95F8X6X_C.H"
//#include "SOC_DebugTouchKey.h"

#define LED1_TurnOver (P17 =~ P17)
#define LED2_TurnOver (P14 =~ P14)
#define LED3_TurnOver (P15 =~ P15)
#define LED4_TurnOver (P20 =~ P20)
#define LED5_TurnOver (P16 =~ P16)
#define LED6_TurnOver (P21 =~ P21)

#define SLIDELED1_ON P03 = 1;
#define SLIDELED2_ON P02 = 1;
#define SLIDELED3_ON P01 = 1;
#define SLIDELED4_ON P00 = 1;
#define SLIDELED5_ON P55 = 1;
#define SLIDELED6_ON P54 = 1;
#define SLIDELED7_ON P53 = 1;
#define SLIDELED8_ON P52 = 1;

#define SLIDELED1_OFF P03 = 0;
#define SLIDELED2_OFF P02 = 0;
#define SLIDELED3_OFF P01 = 0;
#define SLIDELED4_0FF P00 = 0;
#define SLIDELED5_OFF P55 = 0;
#define SLIDELED6_OFF P54 = 0;
#define SLIDELED7_OFF P53 = 0;
#define SLIDELED8_OFF P52 = 0;

#define KEYTIME 150      //ʱ 統ǰʹõ9ʱϵ9*150 + 5*99ǰ
						 //ʱĬϵʱڣʱСڵ4룬ʱ޸ģ

unsigned long int TK_exKeyValueFlag = 0; //ǰְ־
unsigned char exKeyValue = 0;
unsigned char gTkIsValid = 0;
unsigned char KeyValue = 0;
unsigned int touchKeyFlag = 0;

 /**************************************************
*ƣvoid  UartInit(void) 
*ܣuartʼ
*ڲvoid
*ڲvoid  
**************************************************/
void UartInit(unsigned char Fsys, unsigned long baud)
{
	OTCON |= 0XC0;
	
	US1CON0 |= 0X40;
	US1CON1 = (Fsys*1000000/baud) %256;
	US1CON2 = (Fsys*1000000/baud) /256;
	//ʵ֣ڴӡֵֻ
}

 /**************************************************
*ƣvoid  putchar(void) 
*ܣһַ
*ڲvoid
*ڲvoid  
**************************************************/
char putchar(char c)
{
	US1CON3 = c;
	while(!(US1CON0&0x02));
	US1CON0 = US1CON0; 
	//ʵ֣ʵprintfڴӡֵֻ
	return c;
}

 /**************************************************
*ƣvoid  Sys_Init(void) 
*ܣϵͳʼ
*ڲvoid
*ڲvoid  
**************************************************/
void  Sys_Init(void)
{
	//LEDƳʼ
	P0CON |= 0X0F;
	P0PH &= ~0X0F;
	
	P1CON |= 0XF0;
	P1PH &= ~0XF0;
	
	P2CON |= 0X03;
	P2PH &= ~0X03;
	
	P5CON |= 0X3C;
	P5PH &= ~0X3C;
}


void TouchKeyLed_TurnOver(void)   //LED IOڷת
{
	LED1_TurnOver;
	LED2_TurnOver;
	LED3_TurnOver;
	LED4_TurnOver;
	LED5_TurnOver;
	LED6_TurnOver;
}

void ChangeTouchKeyvalue(void)
{
	switch(TK_exKeyValueFlag)
    {        
        case 0x00000004:
		{
			touchKeyFlag++;
			if(touchKeyFlag >= KEYTIME)   //жǷﵽ
			{
				touchKeyFlag = 0;
				exKeyValue = 8;    //
			}
		}
		break;    
        case 0x00000008:exKeyValue = 3;break; 
        case 0x00000010:exKeyValue = 4;break;
		case 0x00000020:exKeyValue = 5;break;    
        case 0x00000040:exKeyValue = 6;break; 
        case 0x00000080:exKeyValue = 7;break;
		
        default:
		{
			if((touchKeyFlag<KEYTIME) && (touchKeyFlag!=0))
			{
				
				exKeyValue = 2;   //̰
			}
			else
			{
				exKeyValue = 0xff;
			}
			touchKeyFlag = 0;
		}
		break;             
    }
}

void UpdateDisplay(void)
{
	if(exKeyValue != 0xff)
    {
		if(gTkIsValid == 0)    //ǰֻһμ
		{			
			gTkIsValid = 1;
			KeyValue=exKeyValue;					
			if(KeyValue != 0)
			{
				switch(KeyValue)
				{
					case 2:LED1_TurnOver;break;    
					case 3:LED2_TurnOver;break; 
					case 4:LED3_TurnOver;break;
					case 5:LED4_TurnOver;break;    
					case 6:LED5_TurnOver;break; 
					case 7:LED6_TurnOver;break;
					case 8:TouchKeyLed_TurnOver();break;
					
					default:exKeyValue = 0xff;break;             
				}
			}
		}                             
    }
    else
    {
        gTkIsValid = 0;        
    }
}


void SlideLED_ALLOFF(void)
{
	SLIDELED1_OFF;
	SLIDELED2_OFF;
	SLIDELED3_OFF;
	SLIDELED4_0FF;
	SLIDELED5_OFF;
	SLIDELED6_OFF;
	SLIDELED7_OFF;
	SLIDELED8_OFF;
}
void level1()
{
	SLIDELED1_ON;
	SLIDELED2_OFF;
	SLIDELED3_OFF;
	SLIDELED4_0FF;
	SLIDELED5_OFF;
	SLIDELED6_OFF;
	SLIDELED7_OFF;
	SLIDELED8_OFF;
}

void level2()
{
	SLIDELED1_ON;
	SLIDELED2_ON;
	SLIDELED3_OFF;
	SLIDELED4_0FF;
	SLIDELED5_OFF;
	SLIDELED6_OFF;
	SLIDELED7_OFF;
	SLIDELED8_OFF;
}

void level3()
{
	SLIDELED1_ON;
	SLIDELED2_ON;
	SLIDELED3_ON;
	SLIDELED4_0FF;
	SLIDELED5_OFF;
	SLIDELED6_OFF;
	SLIDELED7_OFF;
	SLIDELED8_OFF;
}

void level4()
{
	SLIDELED1_ON;
	SLIDELED2_ON;
	SLIDELED3_ON;
	SLIDELED4_ON;
	SLIDELED5_OFF;
	SLIDELED6_OFF;
	SLIDELED7_OFF;
	SLIDELED8_OFF;
}

void level5()
{
	SLIDELED1_ON;
	SLIDELED2_ON;
	SLIDELED3_ON;
	SLIDELED4_ON;
	SLIDELED5_ON;
	SLIDELED6_OFF;
	SLIDELED7_OFF;
	SLIDELED8_OFF;
}

void level6()
{
	SLIDELED1_ON;
	SLIDELED2_ON;
	SLIDELED3_ON;
	SLIDELED4_ON;
	SLIDELED5_ON;
	SLIDELED6_ON;
	SLIDELED7_OFF;
	SLIDELED8_OFF;
}

void level7()
{
	SLIDELED1_ON;
	SLIDELED2_ON;
	SLIDELED3_ON;
	SLIDELED4_ON;
	SLIDELED5_ON;
	SLIDELED6_ON;
	SLIDELED7_ON;
	SLIDELED8_OFF;
}

void level8()
{
	SLIDELED1_ON;
	SLIDELED2_ON;
	SLIDELED3_ON;
	SLIDELED4_ON;
	SLIDELED5_ON;
	SLIDELED6_ON;
	SLIDELED7_ON;
	SLIDELED8_ON;
}

/**************************************************
*ƣvoid DataProcessing(unsigned long int value)
*ܣԴذ֡ɨֵ
*ڲvalue
*ڲvoid  
**************************************************/
void DataProcessing()
{
	if(TKSlideModulePCBArray[0].OutValue != 0)		//жǷ񱻰
	{
		//S1λֵ
//		printf("Bar%d\n",TKSlideModulePCBArray[0].OutValue);
		/*ͬλӦͬLED */
		if((TKSlideModulePCBArray[0].OutValue>0) && (TKSlideModulePCBArray[0].OutValue<=4))
		{
			level1();
		}
		if((TKSlideModulePCBArray[0].OutValue>4) && (TKSlideModulePCBArray[0].OutValue<=8))
		{
			level2();
		}
		if((TKSlideModulePCBArray[0].OutValue>8) && (TKSlideModulePCBArray[0].OutValue<=12))
		{
			level3();
		}
		if((TKSlideModulePCBArray[0].OutValue>12) && (TKSlideModulePCBArray[0].OutValue<=16))
		{
			level4();
		}
		if((TKSlideModulePCBArray[0].OutValue>16) && (TKSlideModulePCBArray[0].OutValue<=20))
		{
			level5();
		}
		if((TKSlideModulePCBArray[0].OutValue>20) && (TKSlideModulePCBArray[0].OutValue<=24))
		{
			level6();
		}
		if((TKSlideModulePCBArray[0].OutValue>24) && (TKSlideModulePCBArray[0].OutValue<=28))
		{
			level7();
		}
		if((TKSlideModulePCBArray[0].OutValue>28) && (TKSlideModulePCBArray[0].OutValue<=32))
		{
			level8();
		}
	}
}


/**************************************************
*ƣvoid  Sys_Scan(void) 
*ܣɨTKʾ
*ڲvoid
*ڲvoid  
**************************************************/
void Sys_Scan(void)
{      		
	if(SOCAPI_TouchKeyStatus&0x80)	    //Ҫ2:  ɨһֱ־ǷTouchKeyScan()һҪݴ˱־λ
	 {		 
		SOCAPI_TouchKeyStatus &= 0x7f;	//־λ
				

		TK_exKeyValueFlag = TouchKeyScan();		//ɨ账ȡذ״̬
		DataProcessing();						//ɨTKݲ
		ChangeTouchKeyvalue();					//ֵת
		UpdateDisplay();						//õֵ ӦLED
		 
		TouchKeyRestart();				//һת																												 			
	}		  	   
}


/**************************************************
*ƣvoid main(void) 
*ܣ
*ڲvoid
*ڲvoid
*˵
**************************************************/
void main(void)
{   	
	Sys_Init();	//ϵͳʼ	
	
	TouchKeyInit();	  //ذʼ

	while(1)
	{
		Sys_Scan();	//ɨ
	}
}
